% Finaquant Analytics - www.finaquant.com
% Copyright: Tunc Ali Ktkcoglu  2012, version: 6August2012
% TITLE: Efficient risk frontier
%
% Deriving minimum or maximum expected risk points (i.e. standard deviation) 
% and corresponding asset weights for a given expected returns with 
% constrained optimization function fmincon()
%
% Central download page:
% http://finaquant.com/download
function PortfReturn = PortfolioReturn(MeanReturns, AssetWeights)
% input parameters:
% MeanReturns: Mean (expected) return for each risky asset; Mx1 matrix for
%   M assets
% AssetWeights: Mx1 matrix (i.e. vector) with weight coefficients of each risky asset
%   with values between 0 and 1

% check matrix sizes
if isempty(MeanReturns) || isempty(AssetWeights)
    error ('Empty vector(s)!');
end
if size(MeanReturns,2) ~= 1
    error ('MeanReturns must be a Mx1 matrix!');
end
if size(AssetWeights,2) ~= 1
    error ('AssetWeights must be a Mx1 matrix!');
end
if size(AssetWeights,1) ~= size(MeanReturns,1)
    error ('The vectors AssetWeights and MeanReturns must have identical lengths!');
end

% size checks done, continue ...
PortfReturn = sum(MeanReturns' * AssetWeights);